;/* $Header: /lsid/semaphore/clarinet/custom/srcusr2.asm 1.5 1998/04/30 23:22:52 fredwc Exp $ */
;/* (C) Copyright 1997, Hewlett-Packard Company, all rights reserved. */
;/* */

;/* This template is derived srcusr.asm */
;/*	and  uses the arbbb2 setup parameters and dynamic cmds */

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 980430 Changes:
;       * Changed output behaviour when OVERREADs occur to
;         mute and turn signal off to prevent channel swap

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 970724 Changes:
;	* speed up on the fly commands by removing unneeded interrupt enable
;	* fixed dac overread status, referred to as source underrun in library
;	* fixed arm parameter update
;	* changed jumps to short addressing where possible to save time
;	* changed #Fxxxx to #>Fxxxx for consistant results from assembler

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;/* 970616 */
;/* Removed from standard template:  */
;/*	Interpolation filtering */
;/*	Burst mode	*/
;/*	Arb data transfer and playback */
;/*	Synchonous dynamic command execution */
;/*	Trigger out */

;/* Added:  */
;/*	Random signal generation */
;/*	external command to preset seed */
;/*	Parameter download during signal generation */
;/* 	gauss amplitude look up linked to new main software to load table */
;/*        [requires srcrom.bin version 3028, dated 19970611 or later] */
;/*     enabled dac overread status bit */

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	page	80,66,3,3
;	page	136,66,3,3

	opt CC,CEX

	include 'hwaddr_.h'
	include 'dspset_.h'
	include 'srcset_.h'
	include 'sigout_.h'
	include 'exttbl_.h'
;
;;;;;;;;; externals (values taken from ver 961007)
;
; FIXED in monvects.asm with EQU:
F_monv_hostrcvint	equ $0020
F_monv_ssixmitint	equ $0010
;
; FIXED in bufrmps.asm via memromv.ctl:
Fbufr_x_inptr		equ $FFC2
Fbufr_y_inptr		equ $FFC3
;
; FIXED in memromv.ctl:
Fbufr_x_top		equ $FF7F
Fbufr_y_top		equ $FF7F
F_gaussd		equ $DE00
;
; FIXED DATA STRUCTURE  in bufrmstr.asm via memromv.ctl
Fbufparm_in		equ $0D39
Fbufparm_out		equ $0D31
;
; ROUTINES NOW FIXED in exttbl.h (exttbl.asm jump table loaded in main):
;Fext_bufr_read
;Fext_bufr_write
;Fext_bufr_hpxmit_reset
;Fext_bdparms_gaincorr
;Fext_bdparms_gaincorr
;Fext_gaussdsegload

;;;;;;;;; end undefined externals

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Memory use:

; Note for jset ... with out using a register many control variables
;  are in absolute short (00 thru 3f) address space so that a move
;  to a register is not needed
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  MEMORY SPACES:
;   Internal memory is fast, 0 wait state
;   External memory is slower
;	1 wait states for 40 MHz E1432 daughter board
;	2 wait states for 80 MHz 2 channel board, 2 per E1434
;
;   Program Space:
;	P:$0068-P:$0FFF	Signal mode program ($0F98, 3992wds)
;	with fast interrupts (P:$0068-P:$007F)
;		P:$0068-P:$01FF	Internal to dsp (408 words)
;		P:$0200-P:$0FFF	External to dsp (3584 words)
;
;   Variable Space:
;	data memory must be initialized by the program,
;   	no data segments are loaded
;
;	Y:$0000-Y:$00FF	Signal mode internal Y mem (256 words)
;		Y:$0 Fsigoutstatus (see sigout_.h)
;		Y:$1 Fsigoutcontrol (see sigout_.h)
;		Y:$2 Fsigoutxeqcmdflg (see sigout_.h)
;  		Y:$3 - X:Farbb2lastlong_y long variables
;  		Y:Farbb2lastlong_y+1 - Y:$003F 6 bit short addressable Y memory
;  		Y:$0040 -  Y:$00FF internal Y memory
;   	Y:$0100-Y:$01FF	Internal Y ROM, 256 entry sine table
;	Y:$0200-Y:$0BFF	Signal mode external Y mem (2560 words)
;	Y:$5000-Y:$FF7F	External Y RAM, available as signal buffer (44928 words)
;
;   	X:$0000-X:$00FF	Signal mode program internal X mem (256 words)
;		X:$0-$2 unused
;  		X:$3 - X:Farbb2lastlong_x long variables
;  		X:Farbb2lastlong_x+1 - X:$003F 6 bit short addressable X memory
;  		X:$0040 -  X:$00FF internal X memory
;   	X:$0100-X:$01FF	Internal X ROM, A law and MU law, NOT USED
;   	X:$5000-X:$DDFF	External X RAM, available as signal buffer
;   	X:$DE00-X:$FDFF External X RAM, used by gauss amplitude look up table, if loaded

;  	L:$3 - L:Farbb2lastlong long variables


;   REGISTERS AND ACCUMULATORS:
;
;   DONOT USE r3, m3, n3, r4, m4, n4, r5, m5, n5, r6, m6, n6,
;       except as shown in this code.
;	r3, r4, r5 reserved for fast interrupt routines
;		r4 (outbound pointer), r5 (inbound pointer)
;	r6 is stack pointer for system code
;
;	ALL other registers, accumulators ... are used somewhere, sometime,
;	and must be saved by the interrupting routine.
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Output signal generation routines
;	Farbbb2init, in external prog memory, initializes all variables
;	F__arbbb2, the output routine, is interruptable by the host port
;	F__arbbb2e, the entry point to the output routine when there is a dac
;		 overread error.

;		Y:0-2 used by sigout variables, see sigout_.h

;###########YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY
; y:$0003 to y:F_arbbb2lastlong_y used for longs
; x:$0003 to x:F_arbbb2lastlong_x used for longs
; l:$0003 to l:F_arbbb2lastlong used for longs
; the following should be duplicated in y:, x: and l:

;                   ORG    l:$0003
;                   ORG    x:$0003
                    ORG    y:$0003

; ### 6 bit short addressed internal variables for fast access
; $0003 .. $003f

;F_arbbb2savereg_b10  ; Long b1 -> x, b0 -> y
;F_arbbb2savereg_b1_x  ; b1 -> x
F_arbbb2savereg_b0_y  ; b0 -> y
        dc      $000000
;F_arbbb2savereg_a10  ; Long a1 -> x, a0 -> y
;F_arbbb2savereg_a1_x  ; a1 -> x
F_arbbb2savereg_a0_y  ; a0 -> y
        dc      $000000
;F_arbbb2savereg_ab2
;F_arbbb2savereg_a2_x ; a2 use x addressing
F_arbbb2savereg_b2_y ; b2 use y addressing
        dc      $000000
;F_arbbb2savereg_x10    ; Long x1 -> x, x0 -> y
;F_arbbb2savereg_x1_x    ; Long x1 -> x, x0 -> y
F_arbbb2savereg_x0_y    ; Long x1 -> x, x0 -> y
        dc      $000000
;F_arbbb2savereg_r7r2
;F_arbbb2savereg_r7_x  ; r7 use x addressing
F_arbbb2savereg_r2_y  ; r2 use y addressing
        dc      $000000

;F_arbbb2longone
;F_arbbb2longone_x
F_arbbb2longone_y
		dc $FFFFFF ; L: one, X is msw 7FFFFF, Y lsw FFFFFF

;F_arbbb2rampgainfactor
;F_arbbb2rampgainfactor_x
F_arbbb2rampgainfactor_y
		dc	$FFFFFF	; L: nearly one $7FFFFF FFFFFF
					; L: upper 24 in x = $7FFFFF
;F_arbbb2rampgaindelta
;F_arbbb2rampgaindelta_x
F_arbbb2rampgaindelta_y
		dc	$999999 ; L: long fract (48 bits)
;					  L: x: = MSW, y: = LSW
;					  x = $000019
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  rampgaindelta data format
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	F_arbbb2rampdelta is gain change at each sample based on the ramp
;	time and interrupt rate, Sample 0.
;	rampgaindelta = 1/(ramptime (sec) * sample rate (samples/sec))
;		for a sample clock of 65536 Hz and a 5 second ramp
;		the rampdelta = 1/(5*65536) = 1/327680
;			      = .000003051757813 = $000019 999999(hex)
;	31 significant bits are sufficent $XXXXXX XX0000 (hex)
;		use doubles for divide and make fraction as follows:
;	long fract = hex signed int of (dec double fraction * 2^(N-1))
;				N = # of bits in the integer
;				N = 32 for a 96000 or a series 700
;	for clock of 51200, ramp delta = 1/(5*51200) = 1/256000
;				= .00000390625 = $000020 c49ba5
;	
;

;F_arbbb2rampdownstart
;F_arbbb2rampdownstart_x
F_arbbb2rampdownstart_y
;F_arbbb2lastlong
;F_arbbb2lastlong_x
F_arbbb2lastlong_y
		dc	$000000 ; L:
; LONG Variables beyond this point interfere with short x and y  variables
;##########################################################

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Flags and other 6 bit addressable and related variables
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

F_arbbb2chnlflgs		dc	$000000
		;	bit
		;	23   df zerocntr set
		;	22   channels done
		;	21   ch1 active
		;	20   ch2 active

F_arbbb2chxflgs_current	dc	$000000
;    23 chout (1 = on, 0 = off)
;    22 chx (0 = channel 1, 1 = channel 2)
;    21 chmode (1= 2 ch mode, 0= 1 ch mode)
;    0-15 points to next F_arbbb2chxflgs

F_arbbb2rampctl	dc	$000000	; Y:
		;	bit	1/0
		;	23   rampingdown
		;	22   rampingup
		;	21   rampupok
		;	20   rampstart

F_arbbb2rampmode	dc	$000000	; Y:
		;	bit	1/0
		;	23   continuous
		;	22   burst
		;       if neither bit is set then rampdownonly is assumed


;;;;; This group updates the channel 1 data block
;;    ANY CHANGES HERE WILL REQUIRE CHANGES IN THE DYNAMIC CMD COPY CODE
;;    PARAMETER RESET AND INITIALIZATION
;;
F_arbbb2ch1cmdgainuser	dc	$7FFFFF ; Y:
F_arbbb2ch1cmdrngdac	dc	$000035 ; Y: 1 Vpk = -19.875 dB = $000035
F_arbbb2ch1cmd		dc	$000000 ; Y: dynamic signal command
;  When true, the cmd data block over writes the channel data block
;
;	bit
;	23	Command flag
;	22	Immediate command
;	20	wait for xeqcmdflg
;	19	send trigger
;;;;;


;;;;; This group updates the channel 2 data block
;;    ANY CHANGES HERE WILL REQUIRE CHANGES IN THE DYNAMIC CMD COPY CODE
;;    PARAMETER RESET AND INITIALIZATION
;;
F_arbbb2ch2cmdgainuser	dc	$7FFFFF ; Y:
F_arbbb2ch2cmdrngdac	dc	$000035 ; Y: 1 Vpk = -19.875 dB = $000035
F_arbbb2ch2cmd		dc	$000000 ; Y: dynamic signal command
;  When true, the cmd data block over writes the channel data block
;
;	bit
;	23	Command flag
;	22	Immediate command
;	20	wait for xeqcmdflg
;	19	send trigger
;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;  Mode specific variables
;

;;;;;  CHANNEL 1
;;;;; This group is updated by dynamic signal commands

;;    ANY CHANGES HERE WILL REQUIRE CHANGES IN THE DYNAMIC CMD COPY CODE
;;    PARAMETER RESET AND INITIALIZATION
;;
F_arbbb2ch1flgs		dc	F_arbbb2ch1flgs ; Y:
;  bit
;    23 chout (1 = on, 0 = off)
;    22 chx (0 = channel 1, 1 = channel 2)
;    21 chmode (1= 2 ch mode, 0= 1 ch mode)
;    0-15 points to next F_arbbb2chxflgs
F_arbbb2ch1cmdptr	dc	F_arbbb2ch1cmd ; Y:
F_arbbb2ch1trgout	dc	$000000 ; Y: bit 19 of cmd word written here
F_arbbb2ch1signal	dc	$000000 ; Y:
F_arbbb2ch1gaincorr	dc	$5bf43b ; Y:
;	  ch correction has a nominal value = 10/13.92, always less than 1
F_arbbb2ch1gainuser	dc	$7FFFFF ; Y:
F_arbbb2ch1rngdac	dc	$000035 ; Y: 1 Vpk = -19.875 dB = $000035
;;
;;;;;

;;;;;  CHANNEL 2
;;;;; This group is updated by dynamic signal commands

;;    ANY CHANGES HERE WILL REQUIRE CHANGES IN THE DYNAMIC CMD COPY CODE

F_arbbb2ch2flgs		dc	F_arbbb2ch1flgs ; Y:
;  bit
;    23 chout (1 = on, 0 = off)
;    22 chx (0 = channel 1, 1 = channel 2)
;    21 chmode (1= 2 ch mode, 0= 1 ch mode)
;    0-15 points to next F_arbbb2chxflgs
F_arbbb2ch2cmdptr	dc	F_arbbb2ch2cmd ; Y:
F_arbbb2ch2trgout	dc	$000000 ; Y: bit 19 of cmd word written here
F_arbbb2ch2signal	dc	$000000 ; Y:
F_arbbb2ch2gaincorr	dc	$5bf43b ; Y:
;	  ch correction has a nominal value = 10/13.92, always less than 1
F_arbbb2ch2gainuser	dc	$7FFFFF ; Y:
F_arbbb2ch2rngdac	dc	$000035 ; Y: 1 Vpk = -19.875 dB = $000035
;;
;;;;;

; STATIC VARIABLES IN Y SHORT (INTERNAL) MEMORY (to minimize instructions)
;	 order is important as some variables are accessed in sequence
;
F_arbbb2chxptr	dc	F_arbbb2ch1flgs
;		points to F_arbbb2ch1flgs or F_arbbb2ch2flgs.

F_arbbb2bits	dc	FSIG_DFIN_BITS  ;$008000 for DF1700(16 bits)
;	or FSIG_DFOUT_BITS, $080000 for PCM63(20 bits)

F_arbbb2trgoff	dc	$000000

F_arbbb2usercmd_state	dc	$000000
FARBBB2USERCMD1_BIT	equ $000001
FARBBB2USERCMD2_BIT	equ $000002
FARBBB2USERCMD_LENGTH	equ 000036 ; decimal

F_arbbb2sigout		dc	$000000
;	

F_arbbb2dfdelay	dc	$000036
;	measured zero crossing df filter delay .74 ms for Fs = 65536 Hz
;	or 48.49 * 1/fs
;	reset df delay to 54 ($36) allowing for measurment error

;	Although for 2 channel mode the interrupts occur twice as fast
;	the counter is decremented on ch 1 frame only

F_arbbb2dfzeroctr	dc	$000000
F_arbbb2seed		dc	$000000
F_arbbb2rngmute		dc 	$00007F
F_arbbb2parmnotused	dc	$000000
F_arbbb2ch1rngtmp	dc	$000000
F_arbbb2ch2rngtmp	dc	$000000

;###########XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
; y:$0003 to y:F_arbbb2lastlong_y used for longs
; x:$0003 to x:F_arbbb2lastlong_x used for longs
; l:$0003 to l:F_arbbb2lastlong used for longs
; the following should be duplicated in y:, x: and l:

;                   ORG    l:$0003
                    ORG    x:$0003
;                   ORG    y:$0003

; ### 6 bit short addressed internal variables for fast access
; $0003 .. $003f

;F_arbbb2savereg_b10  ; Long b1 -> x, b0 -> y
F_arbbb2savereg_b1_x  ; b1 -> x
;F_arbbb2savereg_b0_y  ; b0 -> y
        dc      $000000
;F_arbbb2savereg_a10  ; Long a1 -> x, a0 -> y
F_arbbb2savereg_a1_x  ; a1 -> x
;F_arbbb2savereg_a0_y  ; a0 -> y
        dc      $000000
;F_arbbb2savereg_ab2
F_arbbb2savereg_a2_x ; a2 use x addressing
;F_arbbb2savereg_b2_y ; b2 use y addressing
        dc      $000000
;F_arbbb2savereg_x10    ; Long x1 -> x, x0 -> y
F_arbbb2savereg_x1_x    ; Long x1 -> x, x0 -> y
;F_arbbb2savereg_x0_y    ; Long x1 -> x, x0 -> y
        dc      $000000
;F_arbbb2savereg_r7r2
F_arbbb2savereg_r7_x  ; r7 use x addressing
;F_arbbb2savereg_r2_y  ; r2 use y addressing
        dc      $000000

;F_arbbb2longone
F_arbbb2longone_x
;F_arbbb2longone_y
		dc $FFFFFF ; L: one, X is msw 7FFFFF, Y lsw FFFFFF

;F_arbbb2rampgainfactor
F_arbbb2rampgainfactor_x
;F_arbbb2rampgainfactor_y
		dc	$FFFFFF	; L: nearly one $7FFFFF FFFFFF
					; L: upper 24 in x = $7FFFFF
;F_arbbb2rampgaindelta
F_arbbb2rampgaindelta_x
;F_arbbb2rampgaindelta_y
		dc	$999999 ; L: long fract (48 bits)
;F_arbbb2rampdownstart
F_arbbb2rampdownstart_x
;F_arbbb2rampdownstart_y
;F_arbbb2lastlong
F_arbbb2lastlong_x
;F_arbbb2lastlong_y
		dc	$000000 ; L:
; LONG Variables beyond this point interfere with short x and y  variables
;##########################################################

F_arbbb2_txout		dc	0

F_arbbb2usercmd1_dest
			DUP FARBBB2USERCMD_LENGTH
			dc	0
			ENDM
F_arbbb2usercmd2_dest
			DUP FARBBB2USERCMD_LENGTH
			dc	0
			ENDM
F_arbbb2usercmd1_base
			DUP FARBBB2USERCMD_LENGTH
			dc	0
			ENDM
F_arbbb2usercmd2_base
			DUP FARBBB2USERCMD_LENGTH
			dc	0
			ENDM

F_arbbb2lastx		dc	0

; x space must end before $100
;##########################################################
;##########################################################

;###########LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL
; y:$0003 to y:F_arbbb2lastlong_y used for longs
; x:$0003 to x:F_arbbb2lastlong_x used for longs
; l:$0003 to l:F_arbbb2lastlong used for longs
; the following should be duplicated in y:, x: and l:

                    ORG    l:$0003
;                   ORG    x:$0003
;                   ORG    y:$0003

; ### 6 bit short addressed internal variables for fast access
; $0003 .. $003f

F_arbbb2savereg_b10  ; Long b1 -> x, b0 -> y
;F_arbbb2savereg_b1_x  ; b1 -> x
;F_arbbb2savereg_b0_y  ; b0 -> y
        dc      $000000
F_arbbb2savereg_a10  ; Long a1 -> x, a0 -> y
;F_arbbb2savereg_a1_x  ; a1 -> x
;F_arbbb2savereg_a0_y  ; a0 -> y
        dc      $000000
F_arbbb2savereg_ab2
;F_arbbb2savereg_a2_x ; a2 use x addressing
;F_arbbb2savereg_b2_y ; b2 use y addressing
        dc      $000000
F_arbbb2savereg_x10    ; Long x1 -> x, x0 -> y
;F_arbbb2savereg_x1_x    ; Long x1 -> x, x0 -> y
;F_arbbb2savereg_x0_y    ; Long x1 -> x, x0 -> y
        dc      $000000
F_arbbb2savereg_r7r2
;F_arbbb2savereg_r7_x  ; r7 use x addressing
;F_arbbb2savereg_r2_y  ; r2 use y addressing
        dc      $000000

F_arbbb2longone
;F_arbbb2longone_x
;F_arbbb2longone_y
		dc $FFFFFF ; L: one, X is msw 7FFFFF, Y lsw FFFFFF

F_arbbb2rampgainfactor
;F_arbbb2rampgainfactor_x
;F_arbbb2rampgainfactor_y
		dc	$FFFFFF	; L: nearly one $7FFFFF FFFFFF
					; L: upper 24 in x = $7FFFFF
F_arbbb2rampgaindelta
;F_arbbb2rampgaindelta_x
;F_arbbb2rampgaindelta_y
		dc	$999999 ; L: long fract (48 bits)
F_arbbb2rampdownstart
;F_arbbb2rampdownstart_x
;F_arbbb2rampdownstart_y
F_arbbb2lastlong
;F_arbbb2lastlong_x
;F_arbbb2lastlong_y
		dc	$000000 ; L:
; LONG Variables beyond this point interfere with short x and y  variables
;##########################################################


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	org	p:$68

;;; the following interrupts vectors starting at p:$68 are defined
;;; by the source mode
			; sigout src mode imed cmd 12
ARBBB2CMD_B4	jsr >F__arbbb2_dyncmdend ; end dyn cmd mode

ARBBB2CMD_B5	jsr >F__arbbb2_dyncmdch1 ; setup dyn cmd for ch 1

ARBBB2CMD_B6	jsr >F__arbbb2_dyncmdch2 ; setup dyn cmd for ch 2

ARBBB2CMD_B7	nop	; sigout src mode imed cmd 9
		rts
ARBBB2CMD_B8	nop	; sigout src mode imed cmd 8
		rts
ARBBB2CMD_B9	nop
		rts
ARBBB2CMD_BA	nop
		rts
ARBBB2CMD_BB	jsr >F__arbbb2_usercmd2_done ; sets usercmd2 cmd

ARBBB2CMD_BC	jsr >F__arbbb2_usercmd2_setup ; sets up recdata irq for usercmd2

ARBBB2CMD_BD	jsr >F__arbbb2_usercmd1_done ; sets usercmd1 cmd

ARBBB2CMD_BE	jsr >F__arbbb2_usercmd1_setup ; sets up recdata irq for usercmd1

ARBBB2CMD_BF	rts
		nop

;;;;;;  standard entry points 
Farbbb2_reset	jmp >F__arbbb2reset  ; loads interrupt vectors, constants, etc
Farbbb2_init	jmp >F__arbbb2init   ; initializes with setup parameters
Farbbb2_cmd	jmp >Farbbb2cmd	; executes command from buffer
Farbbb2_bkgnd	rts
;Farbbb2_bkgnd	jmp >F__arbbb2bkgnd ; executes background routine if any

F__arbbb2
	; DEBUG set test bit daughter bd only for timing meas
;		movep #>$2,x:<<Fdsp_pcd ;DEBUG set test bit daughter bd

; Interrupt Procedure Description, in internal prog memory:
;

		bset #21,y:<Fsigoutstatus ; set bit indicating running
					; not waiting for framesync

		move y:<F_arbbb2chxptr,r1	; r1 = &F_arbbb2chxflgs
		clr a
			; initialize filterstate offset and chnl flg (ch1)
; IF CHANNEL 1
;		JSETBUG with r1, y1
;		jset #22,y:(r1)+,F__arbbb2_cnttst	; ch1? no, skip stuff
;		jset or jclr with indirect, y:(r1), doesnot work, 6 places
		move y:(r1)+,y0 ; after increment r1 -> chxcmdptr
		move y0,y:<F_arbbb2chxflgs_current ; after increment r1 -> chxcmdptr
		jset #22,y:<F_arbbb2chxflgs_current,F__arbbb2_ch2cnt	; ch1? no, skip stuff
; THEN

; IF SIGOFF
		jclr #22,y:<Fsigoutcontrol,F__arbbb2_offtest ; sigoffr? no cont.
 						; rmp2sigoff? no cont.
 		jset #23,y:<F_arbbb2rampctl,F__arbbb2_offtest
 				; if rampingdown then skip
 		bset #23,y:<F_arbbb2rampctl	; set ramping down
 		bclr #22,y:<F_arbbb2rampctl	; clear rampingup
 		bclr #21,y:<F_arbbb2rampctl	; clr rampupok

 		; set the ramping bit on the status word
 		movep #>FSISR_RAMPON,y:<<Fsrc_sisr

F__arbbb2_offtest
		jclr #23,y:<Fsigoutcontrol,F__arbbb2_done0 ; sigoff? no cont.
		bset #22,y:<F_arbbb2chnlflgs	; set channels done


; IF CHANNELS DONE, OUTPUT 0 THROUGHOUT SSI AND DF

F__arbbb2_done0	jclr #22,y:<F_arbbb2chnlflgs,F__arbbb2_ch1cnt
						;chnls done?,no,cont.
F__arbbb2_done1	jset #23,y:<F_arbbb2chnlflgs,F__arbbb2_done3 ; yes,df counterset?
			 ; yes then rtn, letting arbbb2e send zeros
		move y:<F_arbbb2dfdelay,y1	      ; no, set up df counter
		move y1,y:<F_arbbb2dfzeroctr
		bset #23,y:<F_arbbb2chnlflgs	      ; set counterset flag
F__arbbb2_done2
	jclr #23,y:<Fsigoutcontrol,F__arbbb2_zerosigout ; not off so dont mute
		jmp <F__arbbb2_sigoutmute	      ; output a zero

F__arbbb2_done3	clr b
		move y:<F_arbbb2dfzeroctr,b0
		dec b				;  yes decrement until done
		jmi <F__arbbb2_done4
		move b0,y:<F_arbbb2dfzeroctr
		jmp <F__arbbb2_done2

F__arbbb2_done4	bset #23,y:<Fsigoutstatus	; set bit indicating sig done
		jmp <F__arbbb2_done2

F__arbbb2_ch2cnt
		jset #23,y:<F_arbbb2chnlflgs,F__arbbb2_done2
			; if df cntr set send 0
		jclr #FARBBB2USERCMD2_BIT,y:<F_arbbb2usercmd_state,F__arbbb2_sigcont
	; do cmd2 here
		bclr #FARBBB2USERCMD2_BIT,y:<F_arbbb2usercmd_state
	; set r2 = cmd2_base, set r7 to destination
		move #>F_arbbb2usercmd2_base,r2
		move r7,x:<F_arbbb2savereg_r7_x
        	move #>F_arbbb2usercmd2_dest,r7
		jmp <F__arbbb2usrcmd_cp

F__arbbb2_ch1cnt

		jclr #23,y:<F_arbbb2rampctl,F__arbbb2ramp2 ; not ramp up
; IF RAMPING DOWN
		move l:<F_arbbb2rampgaindelta,a
		move l:<F_arbbb2rampgainfactor,b
		sub a,b 
	; rampfactor = rampfactor -rampdelta
		jgt <F__arbbb2ramp3 ; rampdown not done, continue

	; if rampfactor <= 0, rampdown is done
		clr b	;   then rampfactor = 0

		bclr #23,y:<F_arbbb2rampctl	; clr ramping down

		movep #>FSISR_RAMPOFF,y:<<Fsrc_sisr ; set rampoff status bit

	jclr #22,y:<Fsigoutcontrol,F__arbbb2ramp1 ; ramp2sigoff? no

	;	sigoutctl = ramp2sigoff
	bset #22,y:<F_arbbb2chnlflgs	; set chnlsdone and skip rest
	jmp <F__arbbb2ramp3


F__arbbb2ramp1
F__arbbb2ramp1_1		bset #22,y:<F_arbbb2chnlflgs	; set chnlsdone
		jmp 	<F__arbbb2ramp3

F__arbbb2ramp4	
		jclr #23,y:<F_arbbb2rampmode,F__arbbb2ramp5
	;  if rampmode = continuous, then:
		jclr #20,y:<F_arbbb2rampctl,F__arbbb2ramp5
	; if rampupstart is set, then:
		bset #22,y:<F_arbbb2rampctl	; set rampingup
		bclr #21,y:<F_arbbb2rampctl	; clr rampupok
		bclr #20,y:<F_arbbb2rampctl	; clr rampupstart
		; set the ramping bit on the status word
		movep #>FSISR_RAMPON,y:<<Fsrc_sisr
		jmp <F__arbbb2ramp5

F__arbbb2ramp2	jclr #22,y:<F_arbbb2rampctl,F__arbbb2ramp4 ; not ramp down
; IF RAMPING UP
		move l:<F_arbbb2rampgaindelta,a
		move l:<F_arbbb2rampgainfactor,b
		add a,b
	; rampfactor = rampfactor +rampdelta

		move l:F_arbbb2longone,a  ; a = 1
		cmp a,b 
		jlt <F__arbbb2ramp3 ; ramp up not done b < 1

	; if rampfactor >= 1, rampup is done
		tfr a,b ;  then rampfactor = 1

		bclr #22,y:<F_arbbb2rampctl	; clr rampingup

		movep #>FSISR_RAMPOFF,y:<<Fsrc_sisr
	;	set rampdone status bit

F__arbbb2ramp3 move b,l:<F_arbbb2rampgainfactor


F__arbbb2ramp5	 ; ramp test done

		jclr #FARBBB2USERCMD1_BIT,y:<F_arbbb2usercmd_state,F__arbbb2_sigcont
	; do cmd1 here
		bclr #FARBBB2USERCMD1_BIT,y:<F_arbbb2usercmd_state
	; set r2 = cmd1_base, set r7 to destination
		move #>F_arbbb2usercmd1_base,r2
		move r7,x:<F_arbbb2savereg_r7_x
        	move #>F_arbbb2usercmd1_dest,r7
F__arbbb2usrcmd_cp
	; copy parameters
		do #FARBBB2USERCMD_LENGTH,F__arbbb2usrcmd_cpend
		move x:(r2)+,x0
		move x0,x:(r7)+
F__arbbb2usrcmd_cpend
		nop

F__arbbb2_sigcont

; IF IMMEDIATE COMMAND FOR THIS CHANNEL THEN DO COMMAND
F__arbbb2_icmd1
		move y:(r1)+,r7  ; r7 = &F_arbbb2chxcmd 
				 ; after increment r1 -> &arbbb2chxtrigout
		clr a

;		JSETBUG with r1, y1
;		jclr #22,y:(r7),F__arbbb2_xcmdcnt ; bit 22 set is an immediate cmd
 		move y:(r7),b0
 		jclr #22,b0,F__arbbb2_xcmdcnt ; bit 22 set is an immediate cmd

;	Copy command parameter block
F__arbbb2_icmd2	
		move #2,n2	; 2 parameter words excluding command
		move #3,n0	; will skip:  signal, gaincorr
		move r7,r2
		move r1,r0	; r0 = &F_arbbb2chxtrgout
		move y:(r2)-n2,y1 ; r2 = &F_arbbb2chxcmdgainuser
		move y1,y:(r0)+n0 ; cmd to trgout (bit 19 important)
				; r0 = skipped to &F_arbbb2chxgainuser
		move a1,y:(r7)	; clear this command
		move y:(r2)+,y1
		move y1,y:(r0)+	 ; copy gainuser
		move y:(r2)+,y1
		move y1,y:(r0)+	 ; copy rngdac

F__arbbb2_xcmdcnt

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; GET RANDOM SIGNAL

F__arbbb2_getrand
	movep y:<<Fsrc_prn,x1 		; read random number
	movep y:<<Fsrc_prnrst,a1	; clock prn

F__arbbb2_gauss
		move #>$001fff,a ;	use 13 lower bits
		and x1,a 

;  for uniform amplitude distribution: scale bits upward 
;		move a1,x1
;		mpy x1,#13,a
;		move a0,x1

;  for gausian amplitude distribution: look up gausian amplitude from table
		move #>F_gaussd,n1
		move a1,r1
		nop
		move x:(r1+n1),x1	; lookup amplitude

; scale to 1/4 full scale keeping sign bit to avoid filter overload
		move #$3FFFFF,x0
		mpy x1,x0,a
		move a1,x1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; FILTERING
	; begin with broad band noise in x1

		jclr #22,y:<F_arbbb2chxflgs_current,F__arbbb2_filtr1 ; ch1? yes
F__arbbb2_filtr2

	; channel 2 filtering goes here

		move y:<F_arbbb2ch2gaincorr,x0
		move y:<F_arbbb2ch2gainuser,y0
		jmp <F__arbbb2_sigscale

F__arbbb2_filtr1

	; channel 1 filtering goes here

		move y:<F_arbbb2ch1gaincorr,x0
		move y:<F_arbbb2ch1gainuser,y0

	; end with filtered signal in in x1
	;          gaincorr in x0
	;          gainuser in y0


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Signal scaling, correction and ramping
F__arbbb2_sigscale
	; x1 = signal
	; x0 = gain correction
	; y0 = gain user
		mpy	x1,x0,a			
		move	a1,x1
		mpy	y0,x1,a
		move	a1,y1

		move  x:<F_arbbb2rampgainfactor,x1 ; IGNORE ASMBLR WARNING
					; x1 = upper 24 bits of ramp gain
		mpy	y1,x1,a

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

F__arbbb2_sigout
;	a1 = signal
	move 	a1,y0
	move	y:<F_arbbb2bits,x0
        mpy     y0,x0,a x:<F_arbbb2_txout,r2	; x0 is the shift factor
		; for DF1700 x0=$008000
			; shift 2 bytes so MSB is in last 16 bits of b1
                        ; the DF1700 takes last 16 bits msb first
		; for PCM63 x0=$080000
			; shift 3 bytes so MSB is in last 20 bits of b1
                        ; the PCM63 takes last 20 bits msb first
		; r2 loaded with address of SSI tx (x:Fdsp_tx) or
		;	a bit bucket (x:F_arbbb2txnull)
	move    a1,y:<F_arbbb2sigout ; a1 = signal out, save it for debug

	move a1,x:(r2)

;	OUTPUT RANGE
		jclr #22,y:<F_arbbb2chxflgs_current,F__arbbb2_outrng1 ; ch1? yes ouput to rngwr
		move y:<F_arbbb2ch2rngdac,y1
	       	movep    y1,y:<<Fsrc_rng2wr	; ch2 8 LSbits
		jmp <F__arbbb2rtn
F__arbbb2_outrng1 move y:<F_arbbb2ch1rngdac,y1
		movep    y1,y:<<Fsrc_rngwr	; 8 LSbits

;	SETUP THE NEXT INTERRUPT
;	move lower 16 bits of F_arbbb2chxflgs to F_arbbb2chxptr
F__arbbb2rtn
		move y:<F_arbbb2chxptr,r1       ; r1 = &F_arbbb2chxflgs
		nop
		move y:(r1),r2
		move r2,y:<F_arbbb2chxptr

		; set the time slice clock bit on the status word
		movep #>FSISR_TSCLK,y:<<Fsrc_sisr

;		movep #>$0,x:<<Fdsp_pcd ;DEBUG clear test bit when done

	rti	; F__arbbb2

F__arbbb2_sigoutmute

	clr a x:<F_arbbb2_txout,r2
		; r1 loaded with address of SSI tx (x:Fdsp_tx) or
		;	a bit bucket (x:F_arbbb2txnull)

        move    a1,y:<F_arbbb2sigout ; a1 = signal out, save it for debug

;	OUTPUT SIGNAL VALUE
		move a1,x:(r2)

;	OUTPUT MUTE RANGE
		move y:F_arbbb2rngmute,y1
		jclr #22,y:<F_arbbb2chxflgs_current,F__arbbb2_sigoutm1 ; ch1? yes ouput to rngwr
	       	movep  y1,y:<<Fsrc_rng2wr	; ch2 8 LSbits
		jmp <F__arbbb2rtn

F__arbbb2_sigoutm1
		movep    y1,y:<<Fsrc_rngwr	; 8 LSbits
		jmp <F__arbbb2rtn

F__arbbb2_zerosigout
		clr a	; send 0 to dac
		jmp <F__arbbb2_sigout

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   SSI xmit empty interrupt
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   
;   This routine can be in external p memory
;

F__arbbb2e	; DAC/DF overread error
;
	movep #>FSISR_OVERREAD,y:<<Fsrc_sisr  ; set bit indicating dac overread
	movep x:<<Fdsp_ssisr,a1	; clear exception
        ; Mute range dac immediately and turn signal off.  This
        ; is done in order to avoid channel swap in 2 channel mode.
        ; Do this even in 1 channel mode in order to be consistent.
        move y:F_arbbb2rngmute,y1
        movep y1,y:<<Fsrc_rngwr
        movep y1,y:<<Fsrc_rng2wr
        bset #23,y:<Fsigoutcontrol  ; immediate sigoff so that rang dacs
                                    ; won't get reset by dynamic commands
	jmp <F__arbbb2


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;
;;;; WARNING: A dac over read error, when in 2 channel mode, even if only
;;;;          channel is on, has caused data from one channel being
;;;;          output to the wrong channel because of the loss of
;;;;	      synchronization and the serial buffering on the SSI port.
;;;;
;;;;	      When this occurs, last output value is repeated until a new
;;;;	      a new value is sent.  In one channel mode, the last value
;;;;	      is for the same (only) channel.  In 2 channel mode the
;;;;	      last value is from the other channel.  This can cause
;;;;	      unexpected large transcients in the output signal.
;;;;
;;;;          4/30/98 - In order to avoid the channel swap behaviour
;;;;          described above the output range dac's are now muted
;;;;          and the signal turned off as soon as an OVERREAD occurs.
;;;;          Even momentary channel swap glitches should NOT appear
;;;;          on the output (for 16 bit mode) since the external digital
;;;;          interpolation filters give enough group delay time for the
;;;;          muting to occur before the glitch can get to the output.
;;;;          Turning the signal off suddenly should be better in most
;;;;          cases instead of risking the transients and effects from
;;;;          channel swap.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Immediate commands
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

F__arbbb2_dyncmdch1 ; sets up recdata irq for dynmic cmd for ch 1
	; set write pointer to the beginning of dynamic cmd,r5
	move #>F_arbbb2ch1cmdgainuser,r5

F__arbbb2_dyncmdsu
	move	r7,x:<F_arbbb2savereg_r7_x
	; set irq routine to copy, r7
        move    #>F__arbbb2_dyncmd_firq,r7

F__arbbb2_dyncmdsu1
	; save registers
	move    x0,y:<F_arbbb2savereg_x0_y
	move	r2,y:<F_arbbb2savereg_r2_y

F__arbbb2_dyncmdsu2
	; /* copy fast interrupt routine to data interrupt F__hostrcvint */
        move    #>F_monv_hostrcvint,r2
        move    p:(r7)+,x0
        move    x0,p:(r2)+
        move    p:(r7)+,x0
        move    x0,p:(r2)+

	; /* insure non modulo r5 */
	move #$ffffff,m5

	; restore registers
	move	x:<F_arbbb2savereg_r7_x,r7
	move	y:<F_arbbb2savereg_r2_y,r2
        move    y:<F_arbbb2savereg_x0_y,x0

	movep   #>FSISR_CMDACK,y:<<Fsrc_sisr  ; set cmd ack bit
	rti

F__arbbb2_dyncmdch2 ; sets up recdata irq for dynmic cmd for ch 2
	; set write pointer to the beginning of dynamic cmd,r5
	move #>F_arbbb2ch2cmdgainuser,r5
	jmp <F__arbbb2_dyncmdsu

;;;;;;;;

F__arbbb2_dyncmdend
; save registers
	move	r7,x:<F_arbbb2savereg_r7_x

; set irq routine to copy, r7
        move    #>F__arbbb2_dyncmd_fnop,r7
	jmp	<F__arbbb2_dyncmdsu2
;;;;;;;;;

F__arbbb2_dyncmd_firq ; data rec fast interrupt routine dynamic cmd ch 1
	movep   x:<<Fdsp_hrx,y:(r5)+
	nop

F__arbbb2_dyncmd_fnop ; data rec fast interrupt routine dynamic cmd ch 1
	nop
	nop
;;;;;;;;;

F__arbbb2_usercmd2_done ; usercmd2 cmd avail
	; set B full, set ack
	bset #FARBBB2USERCMD2_BIT,y:<F_arbbb2usercmd_state 
	jmp <F__arbbb2_dyncmdend

F__arbbb2_usercmd1_done ; usercmd1 cmd avail
	; set A full, set ack
	bset #FARBBB2USERCMD1_BIT,y:<F_arbbb2usercmd_state 
	jmp <F__arbbb2_dyncmdend

F__arbbb2_usercmd1_setup ; sets up recdata irq usercmd1
	;install data rec intr vector fast IRQ
	; set write pointer to the beginning, r5
	move #>F_arbbb2usercmd1_base,r5
	move	r7,x:<F_arbbb2savereg_r7_x
        move    #>F__arbbb2_usercmd1_firq,r7
	jmp <F__arbbb2_dyncmdsu1

F__arbbb2_usercmd2_setup ; sets up recdata irq usercmd2
	;install data rec intr vector fast IRQ
	; set write pointer to the beginning,r5
	move #>F_arbbb2usercmd2_base,r5
	move	r7,x:<F_arbbb2savereg_r7_x
        move    #>F__arbbb2_usercmd2_firq,r7
	jmp <F__arbbb2_dyncmdsu1

F__arbbb2_usercmd1_firq ; usercmd1 data rec fast interrupt routine
	movep   x:<<Fdsp_hrx,x:(r5)+
	nop

F__arbbb2_usercmd2_firq ; usercmd2 data rec fast interrupt routine
	movep   x:<<Fdsp_hrx,x:(r5)+
	nop
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
F__arbbb2_initvars
;;;;;;;;;;;;;;;;;;;;;; initalize variables
;
;;;;;;;;;;;;;;;;;;;;;; set general signal variables
;

; initialize gain correction factor based on var_src_acr
;  (high or lowband, cal ...)
		jsr Farbbb2gaincorr

; sigout variables:
		clr b
		move b0,y:<Fsigoutstatus
		move b0,y:<Fsigoutxeqcmdflg
		bclr #23,y:<Fsigoutcontrol  ; not immediate sigoff
		bclr #22,y:<Fsigoutcontrol  ; not ramping down

; clear accumulators, counters, and control flags

; F_arbbb2chnlflgs	; active channels set elsewhere
		move b0,y:<F_arbbb2chnlflgs

; F_arbbb2rampctl	dc	$000000	; Y
		move b0,y:<F_arbbb2rampctl

; F_arbbb2usercmd_state	dc	$000000	; Y
		move b0,y:<F_arbbb2usercmd_state

; if rampmode is continuous or burst the initialize for ramp up
		jset #23,y:<F_arbbb2rampmode,F__arbbb2_initvarscrampup ; cont
;#		jset #22,y:<F_arbbb2rampmode,F__arbbb2_initvarsbrampup ; burst
		move #>$7FFFFF,b1	; else init with gain factor of 1
		move #>$FFFFFF,b0
		move b,l:<F_arbbb2rampgainfactor
		jmp F__arbbb2_initvars2

F__arbbb2_initvarscrampup ; continuous (ramp up with start)
			bset #20,y:<F_arbbb2rampctl ; set start rampup
;#			jmp F__arbbb2_initvarsrampup
;#	F__arbbb2_initvarsbrampup ; block (ramp up after burst delay)
;#			bset #21,y:<F_arbbb2rampctl ; set rampup ok
F__arbbb2_initvarsrampup	move b,l:<F_arbbb2rampgainfactor

F__arbbb2_initvars2
; clear signal
		clr b
		move b0,y:<F_arbbb2ch1signal
		move b0,y:<F_arbbb2ch2signal

		move b,y:<F_arbbb2ch1cmd ; clear any pending command
		move b,y:<F_arbbb2ch2cmd ; clear any pending command

; initialize command parameters with current values
; a command copies all parameters
		move y:<F_arbbb2ch1gainuser,y0
		move y0,y:<F_arbbb2ch1cmdgainuser
		move y:<F_arbbb2ch1rngdac,y0
		move y0,y:<F_arbbb2ch1cmdrngdac

		move y:<F_arbbb2ch2gainuser,y0
		move y0,y:<F_arbbb2ch2cmdgainuser
		move y:<F_arbbb2ch2rngdac,y0
		move y0,y:<F_arbbb2ch2cmdrngdac

		clr b
		move b0,y:<F_arbbb2dfzeroctr

		jclr #20,y:<Fsigoutcontrol,F__arbbb2_initvars_free ; freerun?
F__arbbb2_initvars_free

;;;;;;;;;;;;;;;;;;;;;; set signal variables based on HW DF in/out
;
		jclr #18,y:<Fsigoutcontrol,F__arbbb2_initvars_dfin ; is df1700 in?
		move #>FSIG_DFOUT_BITS,b0		; no, df1700 out
		move #>FSIG_DFOUT_DELAY,b1
		jmp F__arbbb2_initvars_dfset
F__arbbb2_initvars_dfin  move #>FSIG_DFIN_BITS,b0	; yes df1700 in
		move #>FSIG_DFIN_DELAY,b1
F__arbbb2_initvars_dfset move b0,y:<F_arbbb2bits
		move b1,y:<F_arbbb2dfdelay

;;;;;;;;;;;;;;;;;;;;;; set signal variables based on single or dual channelmode
;
		move #>F_arbbb2ch1flgs,b0	; set pointer part
		move b0,y:<F_arbbb2ch2flgs
		bset #22,y:<F_arbbb2ch2flgs	; tag as channel 2
; dual ch mode?
		jset #17,y:<Fsigoutcontrol,F__arbbb2_initvars_dual
		move #>F_arbbb2ch1flgs,b0		; no, single
		move b0,y:<F_arbbb2ch1flgs	; set pointer par
		bclr #21,y:<F_arbbb2ch1flgs	; clr 2 ch mod bit
		bclr #21,y:<F_arbbb2ch2flgs
		move #>FCRB_XMIT1,b0
		move b0,y:<F_arbbb2trgoff
		jmp F__arbbb2_initvars_ch1test

F__arbbb2_initvars_dual
		move #>F_arbbb2ch2flgs,b0	; dual channel
		move b0,y:<F_arbbb2ch1flgs	; set pointer part
		bset #21,y:<F_arbbb2ch1flgs	; set 2 ch mod bit
		bset #21,y:<F_arbbb2ch2flgs
		move #>FCRB_XMIT2,b0
		move b0,y:<F_arbbb2trgoff

;;;;;;;;;;;;;;;;;;;;;; set signal variables based on ch1 and/or ch2 on
;
F__arbbb2_initvars_ch1test
		jset #16,y:<Fsigoutcontrol,F__arbbb2_initvars_ch1on ; is ch1 on?
		bclr #23,y:<F_arbbb2ch1flgs	; no
		jmp F__arbbb2_initvars_ch2test
F__arbbb2_initvars_ch1on bset #23,y:<F_arbbb2ch1flgs	; yes
		bset #21,y:<F_arbbb2chnlflgs
F__arbbb2_initvars_ch2test
		jset #15,y:<Fsigoutcontrol,F__arbbb2_initvars_ch2on ; is ch2 on?
		bclr #23,y:<F_arbbb2ch2flgs	; no
		jmp F__arbbb2_initvars_finish
F__arbbb2_initvars_ch2on bset #23,y:<F_arbbb2ch2flgs	; yes
		bset #20,y:<F_arbbb2chnlflgs

F__arbbb2_initvars_finish
		move #>F_arbbb2ch1flgs,b0
		move b0,y:<F_arbbb2chxptr

		rts ; F__arbbb2_initvars

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  INIT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
F__arbbb2init

; 1. Initialize any signal generation variables based on setup
; 2. put the first data point in the dsp output register

; Variables set before calling:
;	used by arbbb2init:

;		Fsigoutcontrol
;
;		F_arbbb2rampmode
;		F_arbbb2rampgaindelta
;		F_arbbb2rampdownstart
;
;		F_arbbb2burstmode
;		F_arbbb2burstdelay
;		F_arbbb2burstend	
;		F_arbbb2holdoffend
;
;		F_arbbb2ch1gaincorr
;		F_arbbb2ch1gainuser
;		F_arbbb2ch1rngdac
;		F_arbbb2ch1seed
;		F_arbbb2ch1spanmode
;
;		F_arbbb2ch2gaincorr
;		F_arbbb2ch2gainuser
;		F_arbbb2ch2rngdac
;		F_arbbb2ch2seed
;		F_arbbb2ch2spanmode
;
;		F_arbbb2dfdelay
;		
;		
;		


; To be c callable, save and restore registers used
; Need to save all registers because the interrupt routine is called.



		jsr F__arbbb2_regallsave

		jclr #0,y:<Fsigoutcontrol,F__arbbb2init_start
;	arm

; set initialize values based on command parameters
; this prevents parameter reset on arm, insuring that a dynamic cmd
; parameter change is not missed.

		move y:<F_arbbb2ch1cmdgainuser,y0
		move y0,y:<F_arbbb2ch1gainuser
		move y:<F_arbbb2ch1cmdrngdac,y0
		move y0,y:<F_arbbb2ch1rngdac

		move y:<F_arbbb2ch2cmdgainuser,y0
		move y0,y:<F_arbbb2ch2gainuser
		move y:<F_arbbb2ch2cmdrngdac,y0
		move y0,y:<F_arbbb2ch2rngdac

		jset #1,y:<Fsigoutcontrol,F__arbbb2init_start
			; else skip resetting seed and
			; else skip resetting state tables and only calc next point

		jsr F__arbbb2_initvars

;     save range dac values
		move    y:<F_arbbb2ch1rngdac,y1
		move    y1,y:F_arbbb2ch1rngtmp
		move    y:<F_arbbb2ch2rngdac,y1
		move    y1,y:F_arbbb2ch2rngtmp

;     mute range dacs
		move y:F_arbbb2rngmute,y1
		movep   y1,y:<<Fsrc_rngwr
		movep   y1,y:<<Fsrc_rng2wr
		move    y1,y:<F_arbbb2ch1rngdac
		move    y1,y:<F_arbbb2ch2rngdac
		jmp	F__arbbb2init_firstpt

F__arbbb2init_start
		jsr F__arbbb2_initvars

;     save range dac values
		move    y:<F_arbbb2ch1rngdac,y1
		move    y1,y:F_arbbb2ch1rngtmp
		move    y:<F_arbbb2ch2rngdac,y1
		move    y1,y:F_arbbb2ch2rngtmp

;     mute range dacs
		move y:F_arbbb2rngmute,y1
		movep   y1,y:<<Fsrc_rngwr
		movep   y1,y:<<Fsrc_rng2wr
		move    y1,y:<F_arbbb2ch1rngdac
		move    y1,y:<F_arbbb2ch2rngdac

; Initialize random seed
;	F_arbbb2seed is lower 8 bits
F__arbbb2init_seed
		move y:F_arbbb2seed,a0
		movep a0,y:Fsrc_prnrst 		; preset the prn
		nop				; wait
		movep y:<<Fsrc_prnrst,a1	; clock prn
F__arbbb2setseeddone

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; call F__arbbb2 to send first point (ch1) to the ssi outbuffer.
;	it also sets the ch1 range dac

F__arbbb2init_firstpt

;	set crb to set up proper mode for the SSI
		move y:<F_arbbb2trgoff,b0
		movep b0,x:<<Fdsp_crb
		jsr	F__arbbb2  ;returning via rti is okay.
F__arbbb2init_end
;	restore range dac values
		move    y:F_arbbb2ch1rngtmp,y1
		move    y1,y:<F_arbbb2ch1rngdac
		move    y:F_arbbb2ch2rngtmp,y1
		move    y1,y:<F_arbbb2ch2rngdac

; To be c callable, save and restore registers
		jsr F__arbbb2_regallrestore
	rts	; F__arbbb2init

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  RESET
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
F__arbbb2reset
;
;	single or dual channel based on sigout_reset setting of Fsigoutcontrol
;	continuous
;	full span
;	full scale amplitude
;	DF 1700 in, range dac set to 1Vpk (-19.875 of full scale).
;	rampgaindelta for 5 seconds ramptime
;
;	no rampup, no bust
;
;	registers used: b, y1, r1, r2
;


; To be c callable, save and restore registers used

		jsr F__arbbb2_regallsave

;	load interrupt vectors

	move #>F__arbbb2_irqs,r1
	move #>F_monv_ssixmitint,r2
	move p:(r1)+,x1
	move x1,p:(r2)+
	move p:(r1)+,x1
	move x1,p:(r2)+
	move p:(r1)+,x1
	move x1,p:(r2)+
	move p:(r1)+,x1
	move x1,p:(r2)+
	jmp F__arbbb2_resetvars

F__arbbb2_irqs
	jsr >F__arbbb2
	jsr >F__arbbb2e
;	jsr >F__arbbb2
;;;

F__arbbb2_resetvars
;	clear x:0, x:1
		clr b
		move b1,x:0
		move b1,x:1

; y:0 (Fsigoutstatus) and y:1 (Fsigoutcontrol) are cleared in sigout_reset

;	clear the rest of internal variable memory, L:$0002-L:$007F 

		move #>$000002,r2
		rep #126
		move b,l:(r2)+
	
;;;;;;;;;;;;;;;;;;;;;; set constant structure pointers
;
;F_arbbb2ch1cmdptr        dc      F_arbbb2ch1cmd ; Y:
		move #>F_arbbb2ch1cmd,b0
		move b0,y:<F_arbbb2ch1cmdptr

;F_arbbb2ch2cmdptr        dc      F_arbbb2ch2cmd ; Y:
		move #>F_arbbb2ch2cmd,b0
		move b0,y:<F_arbbb2ch2cmdptr

;;;;;;;;;;;;;;;;;;;;;; set constants
;
;F_arbbb2rngmute		dc $00007F ; rangedac mute
		move #>$0000EF,b0
		move b0,y:F_arbbb2rngmute

;;;;;;;;;;;;;;;;;;;;;; set default signal parameters
;
;F_arbbb2rampgaindelta    dc      $999999 ; L: long fract (48 bits)
;                                         L: x: = MSW, y: = LSW
;					  x = $000019
;		move #>$000019,b1
;		move #>$999999,b0
;	for clock of 51200, ramp delta = 1/(5*51200) = 1/256000
;				= .00000390625 = $000020 c49ba5
		move #>$000020,b1
		move #>$c49ba5,b0
		move b,l:<F_arbbb2rampgaindelta


;F_arbbb2rampgainfactor   dc      $FFFFFF ; L: nearly one $7FFFFF FFFFFF
                                        ; L: upper 24 in x = $7FFFFF
		move #>$7FFFFF,b1
		move #>$FFFFFF,b0
		move b,l:<F_arbbb2rampgainfactor
		move b,l:F_arbbb2longone

;F_arbbb2ch1gainuser      dc      $7FFFFF ; Y:
		move #>$7FFFFF,b0
		move b0,y:<F_arbbb2ch1gainuser
		move b0,y:<F_arbbb2ch2gainuser
		move b0,y:<F_arbbb2ch1cmdgainuser
		move b0,y:<F_arbbb2ch2cmdgainuser

;F_arbbb2ch1rngdac        dc      $000035 ; Y: 1 Vpk = -19.875 dB = $000035
		move #>$000035,b0
		move b0,y:<F_arbbb2ch1rngdac
		move b0,y:<F_arbbb2ch2rngdac
		move b0,y:<F_arbbb2ch1cmdrngdac
		move b0,y:<F_arbbb2ch2cmdrngdac

;F_arbbb2_txout
		move #>Fdsp_tx,b0
		move b0,x:<F_arbbb2_txout

; Load Gauss inverse positive cdf
	jsr	Fext_gaussdsegload ; loads table to x;$de00

; Make Negative Gauss table
	move 	#$0FFF,n1
	move    #>F_gaussd,r1
	move	#4096,r2
	do r2,F__arbbb2gaussdnegend
	clr b   x:(r1)+,x1
	sub	x1,b
	move	b,x:(r1+n1)	; fills from de00+1+0fff = ee00 to fdff
F__arbbb2gaussdnegend
				; table runs de00-fdff (8196d)

; initialize seed value
	move #>$5,x1
	move x1,y:F_arbbb2seed

; set variables based on Fsigoutcontrol, etc
		jsr F__arbbb2_initvars

; To be c callable, save and restore registers
		jsr F__arbbb2_regallrestore
		rts	; F__arbbb2reset

F__arbbb2_regallsave
; Save all registers
; Once saved, registers may be used by assembly interrupt routine
;      Specific interrupt routines can get by adjusting the stack pointer,
;      r6, and saving only those registers used
;
; A full context save and restore is 59 instructions with added time for
; wait states when accessing external P and Y memory.
;
; Saving SSL and SSL in a sub routine would save the wrong values unless
; the stack is messed with.  This means that when using these routines
; the stack is not expanded.  The stack is only 16 deep so be careful.
;
	move	(r6)+
	; must bump stack pointer by one because it may be
	; pointing at the current not next available location
	move	r0,y:(r6)+
	move	r1,y:(r6)+
	move	r2,y:(r6)+
	move	r7,y:(r6)+
	move	b0,y:(r6)+
	move	b1,y:(r6)+
	move	b2,y:(r6)+
	move	x0,y:(r6)+
	move	x1,y:(r6)+
	move	y0,y:(r6)+
	move	y1,y:(r6)+
	move	n0,y:(r6)+
	move	n1,y:(r6)+
	move	n2,y:(r6)+
	move	n6,y:(r6)+
	move	n7,y:(r6)+
	move	m0,y:(r6)+
	move	m1,y:(r6)+
	move	m2,y:(r6)+
;	move	m6,y:(r6)+
	move	m7,y:(r6)+
	move	a0,y:(r6)+
	move	a1,y:(r6)+
	move	a2,y:(r6)+
; need to initialize used m registers since an assembler routine could
; be interrupted that may have changed them
	move	#$FFFF,m0
	move	#$FFFF,m1
	move	#$FFFF,m2
;	move	#$FFFF,m6
	move	#$FFFF,m7
	rti	; F__arbbb2_regallsave

F__arbbb2_regallrestore
; Restore all registers
	move	y:-(r6),a2
	move	y:-(r6),a1
	move	y:-(r6),a0
	move	y:-(r6),m7
;	move	y:-(r6),m6
	move	y:-(r6),m2
	move	y:-(r6),m1
	move	y:-(r6),m0
	move	y:-(r6),n7
	move	y:-(r6),n6
	move	y:-(r6),n2
	move	y:-(r6),n1
	move	y:-(r6),n0
	move	y:-(r6),y1
	move	y:-(r6),y0
	move	y:-(r6),x1
	move	y:-(r6),x0
	move	y:-(r6),b2
	move	y:-(r6),b1
	move	y:-(r6),b0
	move	y:-(r6),r7
	move	y:-(r6),r2
	move	y:-(r6),r1
	move	y:-(r6),r0
	move	(r6)-
	rti	; F__arbbb2_regallrestore

Farbbb2cmd
	move	r0,y:(r6)+
	move	ssh,y:(r6)+
	move	#2,n6
	move	r6,r0
	move	(r6)+n6
	move	b0,y:(r6)+
	move	b1,y:(r6)+
	move	r1,y:(r6)+
; **************************************************
; /* derived from: arbbb2m.c.ux,v 1.3 95/10/31 12:31:40 donm Exp $ */
; 
; #include "page.h"
; 
; #include "bufrs.h"
; 
; #include "hwaddr.h"
; #include "moncmda.h"
; #include "bdparms.h"
; 
; #define		ARBBB2_CH1CMD		0x800031
; #define		ARBBB2_CH2CMD		0x800032
; #define		ARBBB2_SETUP		0x800033
; #define         ARBBB2_BUFRSETUP        0x800034
; #define         ARBBB2_BUFRMAXRD        0x800035
; #define         ARBBB2_SEED	        0x800036
; 
; extern volatile unsigned	_arbbb2rampmode;
; extern volatile unsigned	_arbbb2rampgaindelta;
; extern volatile unsigned	_arbbb2rampdownstart;
; extern volatile unsigned	_arbbb2burstmode;
; extern volatile unsigned	_arbbb2burstdelay;
; extern volatile unsigned	_arbbb2burstend;	
; extern volatile unsigned	_arbbb2holdoffend;
; extern volatile unsigned	_arbbb2ch1gaincorr;
; extern volatile unsigned	_arbbb2ch1gainuser;
; extern volatile unsigned	_arbbb2ch1rngdac;
; extern volatile unsigned	_arbbb2ch2gaincorr;
; extern volatile unsigned	_arbbb2ch2gainuser;
; extern volatile unsigned	_arbbb2ch2rngdac;
; extern volatile unsigned	_arbbb2dfdelay;
; extern volatile unsigned	_arbbb2ch1cmdgainuser;
; extern volatile unsigned	_arbbb2ch1cmdrngdac;
; extern volatile unsigned	_arbbb2ch1cmd;
; extern volatile unsigned	_arbbb2ch2cmdgainuser;
; extern volatile unsigned	_arbbb2ch2cmdrngdac;
; extern volatile unsigned	_arbbb2ch2cmd;
; extern volatile unsigned	_arbbb2spanmode;
; extern volatile unsigned	_arbbb2_srcbuffer_x_max;
; extern volatile unsigned	_arbbb2_srcbuffer_y_max;
; extern volatile unsigned	_arbbb2_srcbuffer_x_size;
; extern volatile unsigned	_arbbb2_srcbuffer_y_size;
; extern volatile unsigned	_arbbb2_srcbuffer_initmode;
; extern volatile unsigned	_arbbb2_srcbuffer_mode;
; extern volatile unsigned	__arbbb2_srcbuffer_init();
; 
; void
; arbbb2cmd(unsigned extcmd)		/*______*/
; /* arbbb2 extended messages */
; /* test passes command then do the appropriate extended message */
; 
; /* WARNING: the # of cases in a switch statement must be limited to
;    3 or less to avoid creating a jmp table in y mem.  This use
;    of initilized y memory is incompatible with this overlayed code */
; 
; {
;     unsigned msw, temp0;
;     switch (extcmd){
; **************************************************
	move	#-3,n0
	move	#>8388658,b
	move	y:(r0+n0),a
	move	#0,a2
	move	#0,b2
	cmp	b,a
	jeq	L4
	move	#>8388662,b
	move	#0,a2
	move	#0,b2
	cmp	b,a
	jeq	L21    ; arbbb2_seed
	move	#>8388657,b
	move	#0,a2
	move	#0,b2
	cmp	b,a
	jeq	L3
	move	#>8388659,b
	move	#0,a2
	move	#0,b2
	cmp	b,a
	jeq	L5
	jmp	L7

L21
; **************************************************
; 
;   case ARBBB2_SEED:
	move	#>F_arbbb2seed,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-

	jmp	L2
L3
; **************************************************
; 
;   case ARBBB2_CH1CMD:
;       /* read in channel 1 dynamic parameters */
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch1cmdgainuser);
; **************************************************
	move	#>F_arbbb2ch1cmdgainuser,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch1cmdrngdac);
; **************************************************
	move	#>F_arbbb2ch1cmdrngdac,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch1cmd);
; **************************************************
	move	#>F_arbbb2ch1cmd,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       break;
; **************************************************
	jmp	L2
L4
; **************************************************
; 
;   case ARBBB2_CH2CMD:
;       /* read in channel 2 dynamic parameters */
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch2cmdgainuser);
; **************************************************
	move	#>F_arbbb2ch2cmdgainuser,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch2cmdrngdac);
; **************************************************
	move	#>F_arbbb2ch2cmdrngdac,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch2cmd);
; **************************************************
	move	#>F_arbbb2ch2cmd,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       break;
; **************************************************
	jmp	L2
L5
; **************************************************
; 
;   case ARBBB2_SETUP:
;       /* read in setup parameters */
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2rampmode);
; **************************************************
	move	#>F_arbbb2rampmode,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, &msw);	/* msw first, in x: */
; **************************************************
	move	r0,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       memwritex((unsigned*)&_arbbb2rampgaindelta,msw);
; **************************************************
	move	y:(r0),a

	; IGNORE WARNING BELOW (setting x part of l: with y label)
	move	a1,x:F_arbbb2rampgaindelta

;	move	a1,y:(r6)+
;	move	#>F_arbbb2rampgaindelta,r1
;	move	r1,y:(r6)+
;	jsr	Fmemwritex
;	move	(r6)-
;	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2rampgaindelta);
; **************************************************
	move	#>F_arbbb2rampgaindelta,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, &msw);	/* msw first, in x: */
; **************************************************
	move	#>F_arbbb2parmnotused,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       memwritex((unsigned*)&_arbbb2rampdownstart,msw);
; **************************************************
;	move	y:(r0),a

	; IGNORE ERROR BELOW (setting x part of l: with y label)
;	move	a1,x:F_arbbb2parmnotused

;	move	a1,y:(r6)+
;	move	#>F_arbbb2parmnotused,r1
;	move	r1,y:(r6)+
;	jsr	Fmemwritex
;	move	(r6)-
;	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2rampdownstart);
; **************************************************
	move	#>F_arbbb2parmnotused,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2burstmode);
; **************************************************
	move	#>F_arbbb2parmnotused,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, &msw);	/* msw first, in x: */
; **************************************************
	move	#>F_arbbb2parmnotused,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       memwritex((unsigned*)&_arbbb2burstdelay,msw);
; **************************************************
;	move	y:(r0),a

	; IGNORE ERROR BELOW (setting x part of l: with y label)
;	move	a1,x:F_arbbb2burstdelay

;	move	a1,y:(r6)+
;	move	#>F_arbbb2burstdelay,r1
;	move	r1,y:(r6)+
;	jsr	Fmemwritex
;	move	(r6)-
;	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2burstdelay);
; **************************************************
	move	#>F_arbbb2parmnotused,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, &msw);	/* msw first, in x: */
; **************************************************
	move	#>F_arbbb2parmnotused,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       memwritex((unsigned*)&_arbbb2burstend,msw);
; **************************************************
;	move	y:(r0),a

	; IGNORE ERROR BELOW (setting x part of l: with y label)
;	move	a1,x:F_arbbb2burstend

;	move	a1,y:(r6)+
;	move	#>F_arbbb2burstend,r1
;	move	r1,y:(r6)+
;	jsr	Fmemwritex
;	move	(r6)-
;	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2burstend);	
; **************************************************
	move	#>F_arbbb2parmnotused,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, &msw);	/* msw first, in x: */
; **************************************************
	move	#>F_arbbb2parmnotused,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       memwritex((unsigned*)&_arbbb2holdoffend,msw);
; **************************************************
;	move	y:(r0),a

	; IGNORE ERROR BELOW (setting x part of l: with y label)
;	move	a1,x:F_arbbb2holdoffend

;	move	a1,y:(r6)+
;	move	#>F_arbbb2holdoffend,r1
;	move	r1,y:(r6)+
;	jsr	Fmemwritex
;	move	(r6)-
;	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2holdoffend);
; **************************************************
	move	#>F_arbbb2parmnotused,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch1gaincorr);
; **************************************************
	move	#>F_arbbb2ch1gaincorr,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch1gainuser);
; **************************************************
	move	#>F_arbbb2ch1gainuser,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch1rngdac);
; **************************************************
	move	#>F_arbbb2ch1rngdac,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch2gaincorr);
; **************************************************
	move	#>F_arbbb2ch2gaincorr,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch2gainuser);
; **************************************************
	move	#>F_arbbb2ch2gainuser,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2ch2rngdac);
; **************************************************
	move	#>F_arbbb2ch2rngdac,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2dfdelay);
; **************************************************
	move	#>F_arbbb2dfdelay,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       bufr_read(&bufparm_in, (unsigned*)&_arbbb2spanmode);
; **************************************************
	move	#>F_arbbb2parmnotused,r1
	move	r1,y:(r6)+
	move	#>Fbufparm_in,r1
	move	r1,y:(r6)+
	jsr	Fext_bufr_read
	move	(r6)-
	move	(r6)-
; **************************************************
;       break;
; **************************************************
	jmp	L2
L7
L2
; **************************************************
;   }
;     
;     switch (extcmd){
; **************************************************
	move	#-3,n0
	move	#>8388660,b
	move	y:(r0+n0),a
	move	#0,a2
	move	#0,b2
	cmp	b,a
	jeq	L10
	move	#>8388661,b
	move	#0,a2
	move	#0,b2
	cmp	b,a
	jeq	L11
	jmp	L13
L10
; **************************************************
;   case ARBBB2_BUFRSETUP:
;       /* read in arb srcbuffer parameters */
;       ignore
	jmp	L9
L11
; **************************************************
; 
;   case ARBBB2_BUFRMAXRD:
;       /* returns srcbuffer_x_max and srcbuffer_y_max */
;       /* write out a zero to host port*/
;       ignore
L13
L9
; **************************************************
;   }
; }
; **************************************************
L1
	move	(r6)-
	move	y:(r6)-,r1
	move	y:(r6)-,b
	move	y:(r6),b0
	move	(r0)-
	move	y:(r0)-,ssh
	move	r0,r6
	move	y:(r0),r0
	rts

Farbbb2gaincorr
	move	ssh,y:(r6)+
	move	r1,y:(r6)+
; **************************************************
; **************************************************
; **************************************************
;  void
;  arbbb2gaincorr()               /*______*/
;  /* set randbb gain factors */
;  {
;  bdparms_gaincorr((unsigned*)&_arbbb2ch1gaincorr,(unsigned*)&_arbbb2ch2gaincorr);
; **************************************************
	move	#>F_arbbb2ch2gaincorr,r1
	move	r1,y:(r6)+
	move	#>F_arbbb2ch1gaincorr,r1
	move	r1,y:(r6)+
	jsr	Fext_bdparms_gaincorr
	move	(r6)-
	move	(r6)-
; **************************************************
;  /*  sets gain correction based on acr setting hierachy */
;  }
; **************************************************
L14
	move	(r6)-
	move	y:(r6),r1
	move	y:-(r6),ssh
	nop
	rts
